% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/builtin_itembank.R
\docType{data}
\name{builtin_itembank}
\alias{builtin_itembank}
\title{Collection of items fitting the Rasch model}
\format{
A \code{data.frame} with variables:\tabular{ll}{
   Name \tab Label \cr
   \code{key} \tab String indicating a specific Rasch model \cr
   \code{item} \tab Item name, gsed lexicon \cr
   \code{tau} \tab Difficulty estimate \cr
   \code{label} \tab Label (English) \cr
   \code{instrument} \tab Instrument code \cr
   \code{domain} \tab Domain code \cr
   \code{mode} \tab Administration mode \cr
   \code{number} \tab Item number \cr
}
}
\usage{
builtin_itembank
}
\description{
A data frame with administrative information per item with difficulty
estimates (\code{tau}) from the Rasch model. The item bank provides the basic
information to calculate D-scores. The items in the item bank
are a subset of all items as collected in \link{builtin_itemtable}.
}
\details{
The difficulty estimates were estimated by a Rasch model. The \code{key}
indicates the specific Rasch model used to estimate the difficulty.
Strictly speaking, one can only compare D-score calculated from the
same \code{key}.
}
\note{
Updates:
\itemize{
\item Dec 01, 2022 - Overwrite labels of gto by correct item order.
\item Dec 05, 2022 - Adds key \code{gsed2212}, adding instruments \code{gl1} and \code{gs1}, and
defining correct order for \code{gto}
\item Jan 05, 2023 - Adds instrument \code{gh1} to key \code{gsed2212}
}
}
\examples{
# count number of items per instrument in each key
table(builtin_itembank$instrument, builtin_itembank$key)
}
\seealso{
\code{\link[=dscore]{dscore()}}, \code{\link[=get_tau]{get_tau()}}, \code{\link[=builtin_itemtable]{builtin_itemtable()}}
}
\keyword{datasets}
