% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsb.r
\name{DSBNormalizeProtein}
\alias{DSBNormalizeProtein}
\title{the DSB normalization function}
\usage{
DSBNormalizeProtein(
  cell_protein_matrix,
  empty_drop_matrix,
  denoise.counts = TRUE,
  use.isotype.control = TRUE,
  isotype.control.name.vec = NULL,
  define.pseudocount = FALSE,
  pseudocount.use
)
}
\arguments{
\item{cell_protein_matrix}{the raw protein count data to be normalized cells = columns, proteins = rows}

\item{empty_drop_matrix}{the raw empty droplet protein count data used for background correction}

\item{denoise.counts}{set to TRUE by default (recommended) - defines and regresses each cell's technical component using background proteins in each cell and itotype controls when}

\item{use.isotype.control}{set to TRUE by default (recommended) with denoise.counts = TRUE include isotype controls in defining the ?}

\item{isotype.control.name.vec}{a vector of the names of the isotype control proteins exactly as in the data to be normalized}

\item{define.pseudocount}{TRUE FALSE : false by default users can supply a pseudocount besides the default 10 which is optimal for CITEseq data.}

\item{pseudocount.use}{the pseudocount to use if overriding the default pseudocount by setting efine.pseudocount to TRUE}
}
\value{
a normalized R "matrix" of cells by proteins that can be added to any Seurat, SingleCellExperiment or python anndata object - see vignette
}
\description{
the DSB normalization function
}
\examples{
library(dsb) # lazy load example data cells_citeseq_mtx and empty_drop_matrix included in package

# use a subset of 40 cells and bacground droplets from example data
cells_citeseq_mtx = cells_citeseq_mtx[ ,1:400]
empty_drop_matrix = empty_drop_citeseq_mtx[ ,1:400]

adt_norm = dsb::DSBNormalizeProtein(

  # step I: remove ambient protien noise reflected in counts from empty droplets
  cell_protein_matrix = cells_citeseq_mtx,
  empty_drop_matrix = empty_drop_matrix,

  # recommended step II: model and remove the technical component of each cell's protein library
  denoise.counts = TRUE,
  use.isotype.control = TRUE,
  isotype.control.name.vec = rownames(cells_citeseq_mtx)[67:70]
)

# example II - experiments without isotype controls

adt_norm = dsb::DSBNormalizeProtein(
  cell_protein_matrix = cells_citeseq_mtx,
  empty_drop_matrix = empty_drop_matrix,
  denoise.counts = FALSE
)

}
