% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num_fun.R
\name{base2dec}
\alias{base2dec}
\title{Convert a string of numeral digits from some base into decimal notation.}
\usage{
base2dec(x, base = 2)
}
\arguments{
\item{x}{A (required) sequence of numeric symbols 
(as a character sequence or vector of digits).}

\item{base}{The base or radix of the symbols in \code{seq}. 
Default: \code{base = 2} (binary).}
}
\value{
An integer number (in decimal notation).
}
\description{
\code{base2dec} converts a sequence of numeral symbols (digits) 
from its notation as positional numerals (with some base or radix)
into standard decimal notation (using the base or radix of 10).
}
\details{
The individual digits provided in \code{x} (e.g., from "0" to "9", "A" to "F") 
must be defined in the specified base (i.e., every digit value must be lower 
than the base or radix value). 
See \code{\link{base_digits}} for the sequence of default digits. 

\code{base2dec} is the complement of \code{\link{dec2base}}.
}
\examples{
# (a) single string input:
base2dec("11")   # default base = 2
base2dec("0101")
base2dec("1010")

base2dec("11", base = 3)
base2dec("11", base = 5)
base2dec("11", base = 10)

base2dec("11", base = 12)
base2dec("11", base = 14)
base2dec("11", base = 16)

# (b) numeric vectors as inputs:
base2dec(c(0, 1, 0))
base2dec(c(0, 1, 0), base = 3)

# (c) character vector as inputs:
base2dec(c("0", "1", "0"))
base2dec(c("0", "1", "0"), base = 3)

# (d) multi-digit vectors:
base2dec(c(1, 1))
base2dec(c(1, 1), base = 3)

# Extreme values:
base2dec(rep("1", 32))          # 32 x "1"
base2dec(c("1", rep("0", 32)))  # 2^32
base2dec(rep("1", 33))          # 33 x "1"
base2dec(c("1", rep("0", 33)))  # 2^33
 
# Non-standard inputs:
base2dec("  ", 2)      # no non-spaces: NA
base2dec(" ?! ", 2)    # no base digits: NA
base2dec(" 100  ", 2)  # remove leading and trailing spaces
base2dec("-  100", 2)  # handle negative inputs (value < 0)
base2dec("- -100", 2)  # handle double negations
base2dec("---100", 2)  # handle multiple negations

# Special cases:
base2dec(NA)
base2dec(0)
base2dec(c(3, 3), base = 3)  # Note message!

# Note: 
base2dec(dec2base(012340, base =  9), base =  9)
dec2base(base2dec(043210, base = 11), base = 11)

}
\seealso{
\code{\link{dec2base}} converts decimal numbers into numerals in another base;  
\code{\link{as.roman}} converts integers into Roman numerals.

Other numeric functions: 
\code{\link{base_digits}},
\code{\link{dec2base}()},
\code{\link{is_equal}()},
\code{\link{is_wholenumber}()},
\code{\link{num_as_char}()},
\code{\link{num_as_ordinal}()},
\code{\link{num_equal}()}

Other utility functions: 
\code{\link{base_digits}},
\code{\link{dec2base}()},
\code{\link{is_equal}()},
\code{\link{is_vect}()},
\code{\link{is_wholenumber}()},
\code{\link{num_as_char}()},
\code{\link{num_as_ordinal}()},
\code{\link{num_equal}()}
}
\concept{numeric functions}
\concept{utility functions}
