% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{text_to_sentences}
\alias{text_to_sentences}
\title{Split strings of text \code{x} into sentences.}
\usage{
text_to_sentences(
  x,
  sep = " ",
  split_delim = "\\\\.|\\\\?|!",
  force_delim = FALSE
)
}
\arguments{
\item{x}{A string of text (required), 
typically a character vector.}

\item{sep}{A character inserted as separator/delimiter 
between elements when collapsing multi-element strings of \code{x}.  
Default: \code{sep = " "} (i.e., insert 1 space between elements).}

\item{split_delim}{Sentence delimiters (as regex) 
used to split the collapsed string of \code{x} into substrings. 
Default: \code{split_delim = "\\.|\\?|!"} (rather than \code{"[[:punct:]]"}).}

\item{force_delim}{Boolean: Enforce splitting at \code{split_delim}? 
If \code{force_delim = FALSE} (as per default), 
a standard sentence-splitting pattern is assumed: 
\code{split_delim} is followed by one or more blank spaces and a capital letter. 
If \code{force_delim = TRUE}, splits at \code{split_delim} are 
enforced (without considering spacing or capitalization).}
}
\value{
A character vector (of sentences).
}
\description{
\code{text_to_sentences} splits text \code{x} 
(consisting of one or more character strings) 
into a vector of its constituting sentences.
}
\details{
The splits of \code{x} will occur at given punctuation marks 
(provided as a regular expression, default: \code{split_delim = "\\.|\\?|!"}).   
Empty leading and trailing spaces are removed before returning 
a vector of the remaining character sequences (i.e., the sentences).

The Boolean argument \code{force_delim} distinguishes between 
two splitting modes: 

\enumerate{

  \item If \code{force_delim = FALSE} (as per default), 
  a standard sentence-splitting pattern is assumed: 
  A sentence delimiter in \code{split_delim} must be followed by 
  one or more blank spaces and a capital letter starting the next sentence. 
  Sentence delimiters in \code{split_delim} are not removed 
  from the output.
  
  \item If \code{force_delim = TRUE}, 
  the function enforces splits at each delimiter in \code{split_delim}. 
  For instance, any dot (i.e., the metacharacter \code{"\\."}) is  
  interpreted as a full stop, so that sentences containing dots 
  mid-sentence (e.g., for abbreviations, etc.) are split into parts. 
  Sentence delimiters in \code{split_delim} are removed 
  from the output.
  
  }

Internally, \code{text_to_sentences} first uses \code{\link{paste}} 
to collapse strings (adding \code{sep} between elements) and then 
\code{\link{strsplit}} to split strings at \code{split_delim}.
}
\examples{
x <- c("A first sentence. Exclamation sentence!", 
       "Any questions? But etc. can be tricky. A fourth --- and final --- sentence.")
text_to_sentences(x)
text_to_sentences(x, force_delim = TRUE)

# Changing split delimiters:
text_to_sentences(x, split_delim = "\\\\.")  # only split at "."

text_to_sentences("Buy apples, berries, and coconuts.")
text_to_sentences("Buy apples, berries; and coconuts.", 
                  split_delim = ",|;|\\\\.", force_delim = TRUE)
                  
text_to_sentences(c("123. 456? 789! 007 etc."), force_delim = TRUE)

# Split multi-element strings (w/o punctuation):
e3 <- c("12", "34", "56")
text_to_sentences(e3, sep = " ")  # Default: Collapse strings adding 1 space, but: 
text_to_sentences(e3, sep = ".", force_delim = TRUE)  # insert sep and force split.

# Punctuation within sentences:
text_to_sentences("Dr. who is left intact.")
text_to_sentences("Dr. Who is problematic.")

}
\seealso{
\code{\link{text_to_words}} for splitting text into a vector of words; 
\code{\link{text_to_chars}} for splitting text into a vector of characters; 
\code{\link{count_words}} for counting the frequency of words; 
\code{\link{strsplit}} for splitting strings.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{count_chars_words}()},
\code{\link{count_chars}()},
\code{\link{count_words}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_chars}()},
\code{\link{map_text_coord}()},
\code{\link{map_text_regex}()},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_chars}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()}
}
\concept{text objects and functions}
