% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multiarm_normal.R
\name{Ess_normal}
\alias{Ess_normal}
\title{Expected sample size for phase III for multiarm programs with normally distributed outcomes}
\usage{
Ess_normal(kappa, n2, alpha, beta, Delta1, Delta2, strategy, case)
}
\arguments{
\item{kappa}{threshold value for the go/no-go decision rule}

\item{n2}{total sample size for phase II; must be even number}

\item{alpha}{significance level}

\item{beta}{1-beta power for calculation of sample size for phase III}

\item{Delta1}{assumed true treatment effect for standardized difference in means}

\item{Delta2}{assumed true treatment effect for standardized difference in means}

\item{strategy}{choose Strategy: 1 ("only best promising"), 2 ("all promising") or 3 (both)}

\item{case}{different cases: 1 ("nogo"), 21 (treatment 1 is promising, treatment 2 is not), 22 (treatment 2 is promising, treatment 1 is not), 31 (both treatments are promising, treatment 1 is better), 32 (both treatments are promising, treatment 2 is better)}
}
\value{
The function Ess_normal() returns the expected sample size for phase III when going to phase III when outcomes are normally distributed and we consider multiarm programs, i.e. several phase III trials with different doses or different treatments are performed
}
\description{
Given phase II results are promising enough to get the "go"-decision to go to phase III this function now calculates the expected sample size for phase III given the cases and strategies listed below.
The results of this function are necessary for calculating the utility of the program, which is then in a further step maximized by the \code{optimal_multiarm_normal()} function
}
\examples{
res <- Ess_normal(kappa = 0.1 ,n2 = 50 ,alpha = 0.05, beta = 0.1,
                            Delta1 = 0.375, Delta2 = 0.625, strategy = 3, case = 31)
}
\keyword{internal}
