% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_tte.R
\name{EPsProg_tte}
\alias{EPsProg_tte}
\title{Expected probability of a successful program for time-to-event outcomes}
\usage{
EPsProg_tte(
  HRgo,
  d2,
  alpha,
  beta,
  step1,
  step2,
  w,
  hr1,
  hr2,
  id1,
  id2,
  gamma,
  fixed
)
}
\arguments{
\item{HRgo}{threshold value for the go/no-go decision rule}

\item{d2}{total events for phase II; must be even number}

\item{alpha}{significance level}

\item{beta}{\code{1-beta} power for calculation of sample size for phase III}

\item{step1}{lower boundary for effect size}

\item{step2}{upper boundary for effect size}

\item{w}{weight for mixture prior distribution}

\item{hr1}{first assumed true treatment effect on HR scale for prior distribution}

\item{hr2}{second assumed true treatment effect on HR scale for prior distribution}

\item{id1}{amount of information for \code{hr1} in terms of number of events}

\item{id2}{amount of information for \code{hr2} in terms of number of events}

\item{gamma}{difference in treatment effect due to different population structures in phase II and III}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE \code{hr1} is used as fixed effect}
}
\value{
The output of the functions \code{EPsProg_tte()} is the expected probability of a successful program.
}
\description{
Expected probability of a successful program for time-to-event outcomes
}
\examples{
res <- EPsProg_tte(HRgo = 0.8, d2 = 50, 
                           alpha = 0.025, beta = 0.1, 
                           step1 = 1, step2 = 0.95, 
                           w = 0.3, hr1 = 0.69, hr2 = 0.81,
                           id1 = 280, id2 = 420,
                           gamma = 0, fixed = FALSE)
}
\keyword{internal}
