% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/noel.r
\name{noel}
\alias{noel}
\title{No/Lowest Observed Effect Levels}
\usage{
noel(dosecolumn = "",
      targetcolumn = "",
      data_type = "continuous",
      tests = c("all"),
      alternatives = c("greater", "two.sided"),
      alpha = .05,
      control = "",
      tot.obs = "",
      data = NA)
}
\arguments{
\item{dosecolumn}{Character string, name of dose column to be tested.}

\item{targetcolumn}{Character string, name of response column to be tested.}

\item{data_type}{Allowed values "continuous" (default) or "dichotomous".}

\item{tests}{Available tests depend on data_type.  See details.}

\item{alternatives}{Character string(s) specifying the direction of the alternative hypothesis.
Must be one or more of "greater", "two.sided", or "less".}

\item{alpha}{Significance level (numeric) to be used.}

\item{control}{Level of dose to be used as the control for dichotomous data.}

\item{tot.obs}{Character string, column with number tested at each dose for dichotomous outcomes.}

\item{data}{Input dataframe.  See details for expected formats.}
}
\value{
Tables are printed giving the comparisons of the active dose levels to the zero dose control
along with indications of significance specific to each type of test.
}
\description{
This function calculates and displays the results of the requested no/lowest observed effect level tests.
}
\details{
Dosecolumn should be assigned the name of the dose column in the input dataframe.
Targetcolumn should be assigned the name of the response column in the input dataframe.
Tests is defaulted to run all tests available, given the data_type defined.

If the data_type is defined as "continuous", Dunnett's, Dunn's, and Dunnett's T3 tests
are available and are all executed (default), unless tests is defined as a subset of the
list: c("dunnetts", "dunns", "dunnettst3"). The input data frame is expected to include
a numeric column containing the dose and a numeric column containing a continuous
response variable.

When data_type is defined as "dichotomous" for a dichotomous response variable,
the Fisher's exact test is available and executed, with the tests parameter is either left
at the c("all") default or specified as c("fishers.exact").  The control dose is defaulted
to the lowest observed dose, unless a different control dose is provided as a string to
the control parameter.  The input data frame is expected to include summarized data of
dichotomous outcome tests:  one row for each dose, the total number tested at that dose,
and the total number of events observed at that dose.

The alternative parameter specifies the direction(s) of the alternative hypothesis.
All alternatives listed will be tested.

The alpha level determining significance can be specified.
}
\examples{
# Prints all available tests of no/lowest observed effect levels at default alpha=.05:
data(DRdata)
noel("dose", "MF_Log", data=DRdata)

# Dunnett's T3 tests at user-specified alpha of .01:
data(DRdata)
noel("dose", "MF_Log", tests=c("dunnettst3"), alpha=.01, data=DRdata)

# Fisher's exact test for dichotomous outcome data:
data(DIdata)
noel(dosecolumn = "Dose",
     targetcolumn = "Tumor",
     data_type = "dichotomous",
     tot.obs = "n",
     data = DIdata)
}

