% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/expand.R
\name{expand}
\alias{expand}
\title{Expand Summarized Dichotomous Data for drsmooth}
\usage{
expand(dosecolumn = "",
      targetcolumn = "",
      ncolumn = "",
      data = NA,
      outputfilename = "")
}
\arguments{
\item{dosecolumn}{Character string, name of dose column to be tested.}

\item{targetcolumn}{Character string, name of response column to be tested.}

\item{ncolumn}{Character string, name of N column of total cases per dose.}

\item{data}{Input dataframe.}

\item{outputfilename}{Character string, name of .csv file to be written out.}
}
\value{
A dataframe is returned containing one row for each case in each dose.
If an outputfilename is provided, the df is also written out in a .csv file.
An expanded dataframe or file such as this one is appropriate as
input to the drsmooth function when data_type = "dichotomous".
}
\description{
This function expands summarized dichotomous data for input into drsmooth.
}
\details{
The input data frame to this function is expected to contain a numerical dose column,
identified as 'dosecolumn,' a numerical outcome count column, identified as 'targetcolumn,'
and a numerical N column with the total number of cases tested in the dose group,
identified as 'ncolumn.'  See drsmooth included data DIdata for an example.
This function takes such a summarized dataframe and returns an expanded case-by-case replicate df,
which is suitable as an input to the drsmooth function, with data_type = "dichotomous".
If an outputfilename is provided, the resulting df is also written to the working directory.
}
\examples{
# Generates an expanded dataframe from the included data DIdata:
data(DIdata)
DIdata_expanded <- expand(dosecolumn = "Dose", targetcolumn = "Tumor", ncolumn = "n", data = DIdata)
}

