% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/drsmooth.R
\name{drsmooth}
\alias{drsmooth}
\title{Dose-response Modeling with Smoothing Splines}
\usage{
drsmooth(dosecolumn = "",
         targetcolumn = "",
         data_type = "",
         k = 4,
         return_predict = FALSE,
         write_predict = TRUE,
         STD_bias = TRUE,
         data = NA)
}
\arguments{
\item{dosecolumn}{Name of dose column of interest in dataframe.}

\item{targetcolumn}{Name of response column of interest in dataframe.}

\item{data_type}{Allowed values "continuous" or "dichotomous".}

\item{k}{Dimension of the basis used to represent the smooth term; see Details.}

\item{return_predict}{If TRUE (default FALSE), returns dataframe of predicted values.}

\item{write_predict}{If TRUE (the default), writes the dataframe of predicted values to a .csv file in the working directory.}

\item{STD_bias}{If TRUE (the default), calculates the bias of the slope transition dose, a bootstrapped and resource-intensive computation.}

\item{data}{Input dataframe.}
}
\value{
A plot of the spline-estimated dose-response function along with the actual data.
Also, several key metrics are reported:

STD (slope transition dose): The lowest dose at which the slope of the dose-response function
is significantly (90% two-sided) positive.

STD_l and STD_u: The 90 percent lower and upper confidence bounds on the STD.

STD_bias (experimental): An estimate of the bias associated with the STD:  the difference between the point estimate and
the mean of 1000 bootstrapped STDs.

iLOGEL (experimental: interpolated lowest observed effect level) The lowest dose at which the predicted response
exceeds the 90 percent upper confidence bound of the response at zero dose.  This value
can be anywhere within the dose range -- hence "interpolated."

iLOGEL_l and iLOGEL_u: The 90 percent lower and upper confidence bounds on the iLOGEL.

For data_type = "continuous":
BMD1sd and BMD10: Benchmark doses corresponding to a 1sd and 10% increase in control response, respectively.
BMDL1sd and BMDL10: 90 percent (two-sided) lower bounds on the indicated BMDs.

For data_type = "dichotomous":
BMD1perc, BMD5perc, BMD10perc: Benchmark doses corresponding to a 1%, 5%, and 10% increase in control response, respectively.
BMDL1perc, BMDL5perc, BMDL10perc: 90 percent (two-sided) lower bounds on the indicated BMDs.

-2LL, the number of parameters associated with the spline model, and the AIC.
}
\description{
Generates a spline model given dose and target response columns.
}
\details{
This function generates a spline model with the input dose and target response
columns, plots the spline-estimated dose-response function with its upper and lower
95 percent confidence bounds in green and red respectively along with the actual data, and returns
key metrics related to the dose-response function.  Currently, the program will use
the lowest dose group (whatever its value is) as the basis for iLOGEL and BMD estimates
Normally we would assume that would be zero, but it is not forced to be.

Note that the confidence bounds depicted on the plot are for the dose-response function itself,
and not for the raw data.

The parameter 'k', defaulted to 4, defines the dimensions allowed the smooth term in
estimating the response relation.  With 2 reserved for each end of the smooth, the default
allows for 2 bends in this univariate smooth.  In the case that this appears to overfit the data,
the user may choose to override the default to 3, which would allow only one bend.
}
\examples{
# Produces and plots spline model with confidence bounds, and prints key metrics.
# For the plot only, see spline.plot
# The STD_bias is defaulted here to FALSE to speed run time.
# For continuous outcomes
data(DRdata)
drsmooth("dose", "MF_Log", data_type = "continuous", k = 4, return_predict = FALSE,
write_predict = FALSE, STD_bias = FALSE, data=DRdata)

# For dichotomous outcomes
data(DIdata)
# If necessary, convert summarized dataframe into 1 row per case dataframe (see drsmooth::expand)
DIdata_expanded <- expand(dosecolumn = "Dose", targetcolumn = "Tumor", ncolumn = "n", data = DIdata)

drsmooth("Dose", "Tumor", data_type = "dichotomous", return_predict = FALSE,
write_predict = FALSE, STD_bias = FALSE, data=DIdata_expanded)
}

