% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dr_factor.R
\name{dr_factor}
\alias{dr_factor}
\title{Creating correction factors}
\usage{
dr_factor(.data, corrFactor, dateVar, timeVar, tz = NULL,
    format = c("MDY", "YMD"), keepDateTime = TRUE)
}
\arguments{
\item{.data}{A tbl}

\item{corrFactor}{New variable name for correction factor data}

\item{dateVar}{Name of variable containing date data}

\item{timeVar}{Name of variable containing time data}

\item{tz}{String name of timezone, defaults to system's timezone}

\item{format}{Either "MDY" or "YMD" for \code{dateVar} -
\strong{\emph{deprecated as of \code{driftR} v1.1}}}

\item{keepDateTime}{A logical statement to keep an intermediate dateTime variable}
}
\value{
An object of the same class as \code{.data} with the new correction factor variable added
to the other data in \code{.data} as well as a dateTime variable if keepDateTime = TRUE.
}
\description{
A wrapper around \code{dplyr::mutate()} that creates a correction factor for each observation.
}
\details{
Correction factors are calculated based on the time of the observation and the total amount of time
    that the instrument had been deployed. They are used in the equations for both the one-point and two-point
    drift corrections.
}
\examples{
testData <- data.frame(
   Date = c("9/18/2015", "9/18/2015", "9/18/2015", "9/18/2015", "9/18/2015", "9/18/2015"),
   Time = c("12:10:49", "12:15:50", "12:20:51", "12:25:51", "12:30:51", "12:35:51"),
   Temp = c(14.76, 14.64, 14.57, 14.51, 14.50, 14.63),
   SpCond = c(0.754, 0.750, 0.750, 0.749, 0.749, 0.749),
   stringsAsFactors = FALSE
 )

dr_factor(testData, corrFactor = corrFac, dateVar = Date, timeVar = Time, keepDateTime = TRUE)

}
\seealso{
\code{\link{dr_correctOne}} for correction factor creation,
    \code{\link{dr_correctTwo}} for the two-point drift correction
}
