% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loggompertz.R
\name{loggompertz_gradient_2}
\alias{loggompertz_gradient_2}
\alias{loggompertz_hessian_2}
\alias{loggompertz_gradient_hessian_2}
\title{Log-Gompertz function gradient and Hessian}
\usage{
loggompertz_gradient_2(x, theta)

loggompertz_hessian_2(x, theta)

loggompertz_gradient_hessian_2(x, theta)
}
\arguments{
\item{x}{numeric vector at which the function is to be evaluated.}

\item{theta}{numeric vector with the four parameters in the form
\code{c(alpha, delta, eta, phi)}.}
}
\value{
Gradient or Hessian of the alternative parameterization evaluated at
the specified point.
}
\description{
Evaluate at a particular set of parameters the gradient and Hessian of the
log-Gompertz function.
}
\details{
The log-Gompertz function \verb{f(x; theta)} is defined here as

\verb{f(x; theta) = alpha + delta exp(-(phi / x)^eta)}

where \code{x >= 0}, \code{theta = c(alpha, delta, eta, phi)}, \code{eta > 0}, and
\code{phi > 0}. By convention we set
\verb{f(0; theta) = lim_\{x -> 0\} f(x; theta) = alpha}.

This set of functions use a different parameterization from
\code{link[drda]{loggompertz_gradient}}. To avoid the non-negative
constraints of parameters, the gradient and Hessian computed here are for
the function with \code{eta2 = log(eta)} and \code{phi2 = log(phi)}.

Note that argument \code{theta} is on the original scale and not on the log scale.
}
