% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3.R
\name{naac}
\alias{naac}
\title{Area above the curve}
\usage{
naac(object, xlim = c(-10, 10), ylim = c(0, 1))
}
\arguments{
\item{object}{fit object as returned by \code{\link[drda]{drda}}.}

\item{xlim}{numeric vector of length 2 with the lower and upped bound of the
integration interval. Default is \code{c(-10, 10)}.}

\item{ylim}{numeric vector of length 2 with the lower and upped bound of the
allowed function values. Default is \code{c(0, 1)}.}
}
\value{
Numeric value representing the normalized area above the curve.
}
\description{
Evaluate the normalized area above the curve (NAAC).
}
\details{
The area under the curve (AUC) is simply the integral of the chosen model
\verb{y(x; theta)} with respect to \code{x}.

In real applications the response variable is usually contained within a
known interval. For example, if our response represents relative viability
against a control compound, the curve is then expected to be between 0 and 1.

To make the AUC value comparable between different compounds and/or studies,
this function set a hard constraint on both the \code{x} variable and the function
\code{y}. The intervals can always be changed if needed.

The function \verb{f(x; theta)} that is integrated here is defined as

\verb{f(x; theta) = ylim[1], if y(x; theta) < ylim[1]}

\verb{f(x; theta) = y(x; theta), if ylim[1] <= y(x; theta) <= ylim[2]}

\verb{f(x; theta) = ylim[2], if y(x; theta) > ylim[2]}

Finally, the AUC is normalized by its maximum possible value, that is the
area of the rectangle with width \code{xlim[2] - xlim[1]} and height
\code{ylim[2] - ylim[1]}.

The normalized area above the curve is simply \code{NAAC = 1 - NAUC}.
}
