% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_plan_keywords.R
\name{ignore}
\alias{ignore}
\title{Ignore code}
\usage{
ignore(x = NULL)
}
\arguments{
\item{x}{Code to ignore.}
}
\value{
The argument.
}
\description{
Ignore sections of commands and imported functions.
}
\details{
In user-defined functions and \code{\link[=drake_plan]{drake_plan()}} commands, you can
wrap code chunks in \code{ignore()} to
\enumerate{
\item Tell \code{drake} to not search for dependencies
(targets etc. mentioned in the code) and
\item Ignore changes to the code so downstream targets remain up to date.
To enforce (1) without (2), use \code{\link[=no_deps]{no_deps()}}.
}
}
\section{Keywords}{

\code{\link[=drake_plan]{drake_plan()}} understands special keyword functions for your commands.
With the exception of \code{\link[=target]{target()}}, each one is a proper function
with its own help file.
\itemize{
\item \code{\link[=target]{target()}}: declare more than just the command,
e.g. assign a trigger or transform.
Examples: \url{https://ropenscilabs.github.io/drake-manual/plans.html#large-plans}. # nolint
\item \code{\link[=file_in]{file_in()}}: declare an input file dependency.
\item \code{\link[=file_out]{file_out()}}: declare an output file to be produced
when the target is built.
\item \code{\link[=knitr_in]{knitr_in()}}: declare a \code{knitr} file dependency such as an
R Markdown (\code{*.Rmd}) or R LaTeX (\code{*.Rnw}) file.
\item \code{\link[=ignore]{ignore()}}: force \code{drake} to entirely ignore a piece of code:
do not track it for changes and do not analyze it for dependencies.
\item \code{\link[=no_deps]{no_deps()}}: tell \code{drake} to not track the dependencies
of a piece of code. \code{drake} still tracks the code itself for changes.
\item \code{\link[=drake_envir]{drake_envir()}}: get the environment where drake builds targets.
Intended for advanced custom memory management.
}
}

\examples{
\dontrun{
isolate_example("Contain side effects", {
# Normally, `drake` reacts to changes in dependencies.
x <- 4
make(plan = drake_plan(y = sqrt(x)))
x <- 5
make(plan = drake_plan(y = sqrt(x)))
make(plan = drake_plan(y = sqrt(4) + x))
# But not with ignore().
make(plan = drake_plan(y = sqrt(4) + ignore(x))) # Builds y.
x <- 6
make(plan = drake_plan(y = sqrt(4) + ignore(x))) # Skips y.
make(plan = drake_plan(y = sqrt(4) + ignore(x + 1))) # Skips y.

# ignore() works with functions and multiline code chunks.
f <- function(x) {
  ignore({
    x <- x + 1
    x <- x + 2
  })
  x # Not ignored.
}
make(plan = drake_plan(y = f(2)))
readd(x)
# Changes the content of the ignore() block:
f <- function(x) {
  ignore({
    x <- x + 1
  })
  x # Not ignored.
}
make(plan = drake_plan(x = f(2)))
readd(x)
})
}
}
\seealso{
\code{\link[=file_in]{file_in()}}, \code{\link[=file_out]{file_out()}}, \code{\link[=knitr_in]{knitr_in()}}, \code{\link[=no_deps]{no_deps()}}
}
