% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-mapreduce.R
\name{gather_by}
\alias{gather_by}
\title{Gather multiple groupings of targets}
\usage{
gather_by(plan, ..., prefix = "target", gather = "list",
  append = TRUE, filter = NULL, sep = "_")
}
\arguments{
\item{plan}{Workflow plan data frame of prespecified targets.}

\item{...}{Symbols, columns of \code{plan} to define target groupings.
A \code{gather_plan()} call is applied for each grouping.
Groupings with all \code{NA}s in the selector variables are ignored.}

\item{prefix}{Character, prefix for naming the new targets.
Suffixes are generated from the values of the columns
specified in \code{...}.}

\item{gather}{Function used to gather the targets. Should be
one of \code{list(...)}, \code{c(...)}, \code{rbind(...)}, or similar.}

\item{append}{Logical. If \code{TRUE}, the output will include the
original rows in the \code{plan} argument.
If \code{FALSE}, the output will only include the new
targets and commands.}

\item{filter}{An expression like you would pass to \code{dplyr::filter()}.
The rows for which \code{filter} evaluates to \code{TRUE} will be gathered,
and the rest will be excluded from gathering.
Why not just call \code{dplyr::filter()} before \code{gather_by()}?
Because \code{gather_by(append = TRUE, filter = my_column == "my_value")}
gathers on some targets while including all the original targets
in the output. See the examples for a demonstration.}

\item{sep}{Character scalar, delimiter for creating the names
of new targets.}
}
\value{
A workflow plan data frame.
}
\description{
\code{gather_by()} is no longer recommended.
Consider using transformations instead. Visit
\url{https://ropenscilabs.github.io/drake-manual/plans.html#large-plans}
for the details.
}
\details{
Perform several calls to \code{gather_plan()}
based on groupings from columns in the plan,
and then row-bind the new targets to the plan.
}
\examples{
plan <- drake_plan(
  data = get_data(),
  informal_look = inspect_data(data, mu = mu__),
  bayes_model = bayesian_model_fit(data, prior_mu = mu__)
)
plan <- evaluate_plan(plan, rules = list(mu__ = 1:2), trace = TRUE)
plan
gather_by(plan, mu___from, gather = "rbind")
gather_by(plan, mu___from, append = TRUE)
gather_by(plan, mu___from, append = FALSE)
gather_by(plan, mu__, mu___from, prefix = "x")
gather_by(plan) # Gather everything and append a row.
# You can filter out the informal_look_* targets beforehand
# if you only want the bayes_model_* ones to be gathered.
# The advantage here is that if you also need `append = TRUE`,
# only the bayes_model_* targets will be gathered, but
# the informal_look_* targets will still be included
# in the output.
gather_by(
  plan,
  mu___from,
  append = TRUE,
  filter = mu___from == "bayes_model"
)
}
\seealso{
\code{\link[=drake_plan]{drake_plan()}}
}
