% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-cache.R
\name{drake_cache_log}
\alias{drake_cache_log}
\title{Get a table that represents the state of the cache.}
\usage{
drake_cache_log(path = getwd(), search = TRUE,
  cache = drake::get_cache(path = path, search = search, verbose =
  verbose), verbose = 1L, jobs = 1, targets_only = FALSE)
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.
Ignored if a \code{cache} is supplied.}

\item{search}{Logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{verbose}{Logical or numeric, control printing to the console.
\itemize{
\item \code{0} or \code{FALSE}: print nothing.
\item \code{1} or \code{TRUE}: print only targets to build.
\item \code{2}: plus checks and cache info.
\item \code{3}: plus missing imports.
\item \code{4}: plus all imports.
\item \code{5}: plus execution and total build times for targets.
\item \code{6}: plus notifications when targets are being stored.
}}

\item{jobs}{Number of jobs/workers for parallel processing.}

\item{targets_only}{Logical, whether to output information
only on the targets in your workflow plan data frame.
If \code{targets_only} is \code{FALSE}, the output will
include the hashes of both targets and imports.}
}
\value{
Data frame of the hash keys of the targets and imports
in the cache
}
\description{
This functionality is like
\code{make(..., cache_log_file = TRUE)},
but separated and more customizable. Hopefully, this functionality
is a step toward better data versioning tools.
}
\details{
A hash is a fingerprint of an object's value.
Together, the hash keys of all your targets and imports
represent the state of your project.
Use \code{drake_cache_log()} to generate a data frame
with the hash keys of all the targets and imports
stored in your cache.
This function is particularly useful if you are
storing your drake project in a version control repository.
The cache has a lot of tiny files, so you should not put it
under version control. Instead, save the output
of \code{drake_cache_log()} as a text file after each \code{\link[=make]{make()}},
and put the text file under version control.
That way, you have a changelog of your project's results.
See the examples below for details.
Depending on your project's
history, the targets may be different than the ones
in your workflow plan data frame.
Also, the keys depend on the hash algorithm
of your cache. To define your own hash algorithm,
you can create your own \code{storr} cache and give it a hash algorithm
(e.g. \code{storr_rds(hash_algorithm = "murmur32")})
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
# Load drake's canonical example.
load_mtcars_example() # Get the code with drake_example()
# Run the project, build all the targets.
make(my_plan)
# Get a data frame of all the hash keys.
# If you want a changelog, be sure to do this after every make().
cache_log <- drake_cache_log()
head(cache_log)
# Suppress partial arg match warnings.
suppressWarnings(
  # Save the hash log as a flat text file.
  write.table(
    x = cache_log,
    file = "drake_cache.log",
    quote = FALSE,
    row.names = FALSE
  )
)
# At this point, put drake_cache.log under version control
# (e.g. with 'git add drake_cache.log') alongside your code.
# Now, every time you run your project, your commit history
# of hash_lot.txt is a changelog of the project's results.
# It shows which targets and imports changed on every commit.
# It is extremely difficult to track your results this way
# by putting the raw '.drake/' cache itself under version control.
}
})
}
}
\seealso{
\code{\link[=cached]{cached()}}, \code{\link[=get_cache]{get_cache()}}
}
