% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/static_drake_graph.R
\name{render_static_drake_graph}
\alias{render_static_drake_graph}
\title{Render a static \code{ggplot2}/\code{ggraph} visualization from
\code{\link[=drake_graph_info]{drake_graph_info()}} output.}
\usage{
render_static_drake_graph(graph_info, main = graph_info$default_title)
}
\arguments{
\item{graph_info}{list of data frames generated by
\code{\link[=drake_graph_info]{drake_graph_info()}}.
There should be 3 data frames: \code{nodes}, \code{edges},
and \code{legend_nodes}.}

\item{main}{character string, title of the graph}
}
\value{
A \code{ggplot2} object, which you can modify with more layers,
show with \code{plot()}, or save as a file with \code{ggsave()}.
}
\description{
This function requries packages \code{ggplot2} and \code{ggraph}.
Install them with \code{install.packages(c("ggplot2", "ggraph"))}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Get the code with drake_example("mtcars").
# Instead of jumpting right to vis_drake_graph(), get the data frames
# of nodes, edges, and legend nodes.
config <- drake_config(my_plan) # Internal configuration list
static_drake_graph(config) # Jump straight to the static graph.
# Get the node and edge info that vis_drake_graph() just plotted:
graph <- drake_graph_info(config)
render_static_drake_graph(graph)
})
}
}
\seealso{
\code{\link[=vis_drake_graph]{vis_drake_graph()}}, \code{\link[=sankey_drake_graph]{sankey_drake_graph()}}, \code{\link[=static_drake_graph]{static_drake_graph()}}
}
