% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_pooled.R
\name{test_pooled}
\alias{test_pooled}
\title{Compare pooled digital PCR}
\usage{
test_pooled(input, conf.level = 0.05)
}
\arguments{
\item{input}{object of class \code{\linkS4class{adpcr}} or \code{\linkS4class{dpcr}}.}

\item{conf.level}{confidence level of the intervals and groups.}
}
\value{
data frame with the number of rows equal to the number of experiments 
(not runs). The unit of concentration is the number template molecules per 
nanoliter (nL).
}
\description{
Estimates mean number of template molecules per partition and concentration of sample 
from pooled replicates of experiments.
}
\note{
This function was implemented using the code in supplemental materials in 
Dorazio, 2015 (see References).
}
\examples{
test_pooled(six_panels)
}
\author{
Robert M. Dorazio, Margaret E. Hunter.
}
\references{
Dorazio RM, Hunter ME, \emph{Statistical Models for the Analysis 
and Design of Digital Polymerase Chain Reaction (dPCR) Experiments}. 
Analytical Chemistry 2015. 87(21): p.10886-10893
}

