% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{dpcr-class}
\alias{dpcr}
\alias{dpcr-class}
\title{Class \code{"dpcr"} - general digital PCR}
\description{
A class containing results of any digital PCR experiment. 
Type of data in all columns is specified in slot \code{"type"}.
}
\details{
Possible \code{type} values of \code{dpcr} objects:
\enumerate{
 \item{\code{"ct"}: cycle threshold of each partition,}
 \item{\code{"fluo"}: fluorescence of each partition,}
 \item{\code{"nm"}: number of molecules in each partition,}
 \item{\code{"np"}: status (positive (1) or negative(0)) of each partition,}
 \item{\code{"tnp"}: total number of positive partitions in the run (single 
 value per each run, not per partition).}}
 
Digital PCR data is always a matrix, where columns and rows represent 
respectively runs and data points. For example, matrix with 2 columns and 765 rows
means two runs with 765 data points each. In case of \code{"tnp"} data, each run is
represented by only one measurement, the count of all positive partitions.

The number of partitions is defined in slot \code{n}. In the previous example, 
two runs have 765 data points, but they can have less detected partitions 
(for example some reads may be not available). In this case, the data point will 
have value NA. 

The structure of \code{dpcr} class is described more deeply in the vignette.
}
\section{Slots}{

\describe{
\item{\code{.Data}}{\code{matrix} data from digital PCR experiments. See Details.}

\item{\code{n}}{\code{integer} equal to the number of partitions in each run.}

\item{\code{exper}}{\code{factor} the id or name of experiments.}

\item{\code{replicate}}{\code{factor} the id or name of replicate.}

\item{\code{assay}}{\code{factor} the id or name of the assay.}

\item{\code{type}}{Object of class \code{"character"} defining type of data. See Details.}
}}
\note{
This class should not be directly used. Instead, users should use more 
specific class: \code{\linkS4class{adpcr}}, \code{\linkS4class{ddpcr}},
\code{\linkS4class{qdpcr}} or \code{\linkS4class{rtadpcr}}.
}
\author{
Michal Burdukiewicz.
}
\keyword{classes}

