% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{qtest.dosresmeta}
\alias{qtest.dosresmeta}
\alias{print.qtest.dosresmeta}
\title{Cochran Q Test of Heterogeneity for dosresmeta Models}
\usage{
\method{qtest}{dosresmeta}(object, ...)

\method{print}{qtest.dosresmeta}(x, digits = 3, ...)
}
\arguments{
\item{object}{objects of classe "\code{dosresmeta}".}

\item{\dots}{further arguments passed to or from other methods.}

\item{x}{an object of class "\code{qtest.dosresmeta}".}

\item{digits}{an integer specifying the number of digits to which printed results must be rounded.}
}
\description{
This method function performs a Cochran Q test of (residual) heterogeneity on fitted dose-response meta-analytical models 
represented in objects of class "\code{doseremeta}". It is implemented only for a two-stage approach and will return \code{NULL} otherwise.
}
\details{
In (multivariate) dose-response meta-analytical models, the test assesses the null hypothesis that the variability in the 
(multivariate) distribution of the outcomes is explained only in terms of estimation error in each study, measured by the within-study (co)variance matrices 
stored in the component \code{Slist} of \code{dosresmeta} objects. This is equal to test the hypothesis that the between-study (co)variance matrix is 
a zero matrix, and there is no random deviation in study-specific estimates.
}
