% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dosresmeta.R
\name{dosresmeta.fixed}
\alias{dosresmeta.fixed}
\title{Fixed-Effects Estimator for dosresmeta Models}
\usage{
dosresmeta.fixed(Xlist, Zlist, ylist, Slist, nalist, q, nall, control, ...)
}
\arguments{
\item{Xlist}{a m-dimensional list of study-specific design matrices for the fixed-effects part of the model.}

\item{Zlist}{a m-dimensional list of study-specific design matrices for the random-effects part of the model.}

\item{ylist}{a m-dimensional list of study-specific of vectors of estimated outcomes.}

\item{Slist}{a m-dimensional list of within-study (co)variance matrices of estimated outcomes.}

\item{nalist}{a m-dimensional list of k-dimensional study-specific logical vectors, identifying missing outcomes.}

\item{q, nall}{numeric scalars: number of predictors, number of observations (excluding missing).}

\item{control}{list of parameters for controlling the fitting process, usually internally set to default values by \code{dosresmeta.control}.}

\item{\dots}{further arguments passed to or from other methods. Currently not used.}
}
\value{
This function returns an intermediate list object, whose components are then processed by \code{\link{dosresmeta.fit}}. Other components are 
added later through mvmeta to finalize an object of class "\code{dosresmeta}".
}
\description{
This function implements a generalized least square estimator for fixed-effects dose-response meta-analysis. It is meant to be used internally 
and not directly run by the users.
}
\details{
The estimation involves only the \eqn{p} fixed-effects coefficients. The routine is based on a standard generalized least square (GLS) algorithm 
implemented in the internal function glsfit. The between-study (co)variance matrix is set to zero, so the marginal (co)variance matrix, composed only by 
elements of the within-study component, is assumed as completely known. Similarly to the likelihood-based estimators implemented in 
\code{\link{dosresmeta.ml}} and \code{\link{dosresmeta.reml}}, the computation involves Cholesky and and QR decompositions for computational stability and efficiency.
}
\examples{
data("alcohol_crc")

## Fixed-effect dose-response model assuming linearity
dosresmeta(formula = logrr ~ dose, type = type, id = id, se = se, 
           cases = cases, n = peryears, data = alcohol_crc, method = "fixed")

}
\references{
Gasparrini, A., Armstrong, B.,  Kenward, M. G. (2012). Multivariate meta-analysis for non-linear and other multi-parameter associations. 
Statistics in Medicine, 31(29), 3821-3839.
}
\seealso{
\code{\link{dosresmeta}}, \code{\link{dosresmeta-package}}, \code{\link{dosresmeta.ml}}
}
\author{
Alessio Crippa, \email{alessio.crippa@ki.se}
}
