% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flows.R
\name{dodgr_flows_si}
\alias{dodgr_flows_si}
\title{dodgr_flows_si}
\usage{
dodgr_flows_si(
  graph,
  from,
  to,
  k = 500,
  dens_from = NULL,
  dens_to = NULL,
  contract = FALSE,
  norm_sums = TRUE,
  heap = "BHeap",
  tol = 0.000000000001,
  quiet = TRUE
)
}
\arguments{
\item{graph}{\code{data.frame} or equivalent object representing the network
graph (see Details)}

\item{from}{Vector or matrix of points \strong{from} which aggregate flows are to
be calculated (see Details)}

\item{to}{Vector or matrix of points \strong{to} which aggregate flows are to be
calculated (see Details)}

\item{k}{Width of exponential spatial interaction function (exp (-d / k)),
in units of 'd', specified in one of 3 forms: (i) a single vlaue; (ii) a
vector of independent values for each origin point (with same length as
'from' points); or (iii) an equivalent matrix with each column holding values
for each 'from' point, so 'nrow(k)==length(from)'. See Note.}

\item{dens_from}{Vector of densities at origin ('from') points}

\item{dens_to}{Vector of densities at destination ('to') points}

\item{contract}{If \code{TRUE}, calculate flows on contracted graph before
mapping them back on to the original full graph (recommended as this will
generally be much faster).}

\item{norm_sums}{Standardise sums from all origin points, so sum of flows
throughout entire network equals sum of densities from all origins (see
Note).}

\item{heap}{Type of heap to use in priority queue. Options include
Fibonacci Heap (default; \code{FHeap}), Binary Heap (\code{BHeap}),
Trinomial Heap (\code{TriHeap}), Extended Trinomial Heap
(\code{TriHeapExt}, and 2-3 Heap (\code{Heap23}).}

\item{tol}{Relative tolerance below which flows towards \code{to} vertices are not
considered. This will generally have no effect, but can provide speed gains
when flow matrices represent spatial interaction models, in which case this
parameter effectively reduces the radius from each \code{from} point over which
flows are aggregated. To remove any such effect, set \code{tol = 0}.}

\item{quiet}{If \code{FALSE}, display progress messages on screen.}
}
\value{
Modified version of graph with additonal \code{flow} column added.
}
\description{
Aggregate flows throughout a network based using an exponential Spatial
Interaction (SI) model between a specified set of origin and destination
points, and associated vectors of densities.
}
\note{
Spatial Interaction models are often fitted through trialling a range
of values of 'k'. The specification above allows fitting multiple values of
'k' to be done with a single call, in a way that is far more efficient than
making multiple calls. A matrix of 'k' values may be entered, with each
column holding a different vector of values, one for each 'from' point. For a
matrix of 'k' values having 'n' columns, the return object will be a modified
version in the input 'graph', with an additional 'n' columns, named 'flow1',
'flow2', ... up to 'n'. These columns must be subsequently matched by the
user back on to the corresponding columns of the matrix of 'k' values.

The \code{norm_sums} parameter should be used whenever densities at origins
and destinations are absolute values, and ensures that the sum of resultant
flow values throughout the entire network equals the sum of densities at all
origins. For example, with \code{norm_sums = TRUE} (the default), a flow from a
single origin with density one to a single destination along two edges will
allocate flows of one half to each of those edges, such that the sum of flows
across the network will equal one, or the sum of densities from all origins.
The \code{norm_sums = TRUE} option is appropriate where densities are relative
values, and ensures that each edge maintains relative proportions. In the
above example, flows along each of two edges would equal one, for a network
sum of two, or greater than the sum of densities.

With \code{norm_sums = TRUE}, the sum of network flows (\code{sum(output$flow)}) should
equal the sum of origin densities (\code{sum(dens_from)}). This may nevertheless
not always be the case, because origin points may simply be too far from any
denstination (\code{to}) points for an exponential model to yield non-zero values
anywhere in a network within machine tolerance. Such cases may result in sums
of output flows being less than sums of input densities.
}
\examples{
graph <- weight_streetnet (hampi)
from <- sample (graph$from_id, size = 10)
to <- sample (graph$to_id, size = 5)
to <- to [!to \%in\% from]
flows <- matrix (10 * runif (length (from) * length (to)),
                 nrow = length (from))
graph <- dodgr_flows_aggregate (graph, from = from, to = to, flows = flows)
# graph then has an additonal 'flows' column of aggregate flows along all
# edges. These flows are directed, and can be aggregated to equivalent
# undirected flows on an equivalent undirected graph with:
graph_undir <- merge_directed_graph (graph)
# This graph will only include those edges having non-zero flows, and so:
nrow (graph); nrow (graph_undir) # the latter is much smaller
}
