% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-contraction.R
\name{dodgr_contract_graph}
\alias{dodgr_contract_graph}
\title{dodgr_contract_graph}
\usage{
dodgr_contract_graph(graph, verts = NULL)
}
\arguments{
\item{graph}{A flat table of graph edges. Must contain columns labelled
\code{from} and \code{to}, or \code{start} and \code{stop}. May also contain
similarly labelled columns of spatial coordinates (for example
\code{from_x}) or \code{stop_lon}).}

\item{verts}{Optional list of vertices to be retained as routing points.
These must match the \code{from_id} and \code{to_id} columns of \code{graph}.}
}
\value{
A contracted version of the original \code{graph}, converted to a
standardised format.
}
\description{
Removes redundant (straight-line) vertices from graph, leaving only junction
vertices.
}
\examples{
graph <- weight_streetnet (hampi)
nrow (graph) # 5,742
graph <- dodgr_contract_graph (graph)
nrow (graph) # 2,878
}
