% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_all.r
\name{docx_extract_all_tbls}
\alias{docx_extract_all_tbls}
\title{Extract all tables from a Word document}
\usage{
docx_extract_all_tbls(docx, guess_header = TRUE, preserve = FALSE, trim = TRUE)
}
\arguments{
\item{docx}{\code{docx} object read with \code{read_docx}}

\item{guess_header}{should the function make a guess as to the existence of
a header in a table? (Default: \code{TRUE})}

\item{preserve}{preserve line breaks within a cell? Default: `FALSE`. NOTE: This overrides `trim`.}

\item{trim}{trim leading/trailing whitespace (if any) in cells? (default: \code{TRUE})}
}
\value{
\code{list} of \code{data.frame}s or an empty \code{list} if no
        tables exist in \code{docx}
}
\description{
Extract all tables from a Word document
}
\examples{
# a "real" Word doc

real_world <- read_docx(system.file("examples/realworld.docx", package="docxtractr"))
docx_tbl_count(real_world)

# get all the tables
tbls <- docx_extract_all_tbls(real_world)
}
\seealso{
\code{\link{assign_colnames}}, \code{\link{docx_extract_tbl}}
}
