% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx2pdf.R
\name{docx2pdf_install}
\alias{docx2pdf_install}
\title{Install 'docx2pdf'}
\usage{
docx2pdf_install(force = FALSE)
}
\arguments{
\item{force}{Whether to force to install (override) 'docx2pdf'.}
}
\value{
a single logical value, FALSE if the operation failed, TRUE otherwise.
}
\description{
Downloads and installs 'docx2pdf' within a given 'python' distribution.
}
\examples{
library(locatexec)

if(exec_available("python") &&
   exec_version("python") > numeric_version("3") &&
   !docx2pdf_available()) {
  \donttest{
  # this will install and uninstall 'docx2pdf' (i.e. `pip install docx2pdf`)
  # in your python environnement. It can run during 10s and
  # require user to have write permission in python environnement.
  docx2pdf_install()
  docx2pdf_uninstall()
  }
}
}
\seealso{
Other tools for docx2pdf: 
\code{\link{docx2pdf_available}()},
\code{\link{docx2pdf_uninstall}()},
\code{\link{docx2pdf}()}
}
\concept{tools for docx2pdf}
