% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with.DoPar.R
\name{with.DoPar}
\alias{with.DoPar}
\title{Evaluate an Expression using a Temporarily Registered Foreach \verb{\%dopar\%} Adapter}
\usage{
\method{with}{DoPar}(data, expr, ..., local = FALSE, envir = parent.frame())
}
\arguments{
\item{data}{The foreach `\%dopar\% adapter to use temporarily.}

\item{expr}{The R expression to be evaluated.}

\item{local}{If TRUE, then the future plan specified by \code{data}
is applied temporarily in the calling frame. Argument \code{expr} must
not be specified if \code{local = TRUE}.}

\item{envir}{The environment where the adapter should be set and the
expression evaluated.}

\item{\ldots}{Not used.}
}
\value{
Invisibly, the value of \code{expr}.
}
\description{
Evaluate an Expression using a Temporarily Registered Foreach \verb{\%dopar\%} Adapter
}
\examples{
with(registerDoFuture(), {
  y <- foreach(x = 1:3) \%dopar\% { x^2 }
})


a_fcn_in_a_pkg <- function(xs) {
  foreach(x = xs) \%dopar\% { x^2 }
}

with(registerDoFuture(flavor = "\%dofuture\%"), {
  y <- a_fcn_in_a_pkg(1:3)
})
}
