% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt.R
\name{fmt}
\alias{fmt}
\title{Formatting Replacement}
\usage{
fmt(x, ...)
}
\arguments{
\item{x}{format with slash number and one space, which is like "/1 ". 
Number means replacement order.}

\item{...}{values to be passed into x}
}
\value{
replaced string
}
\description{
Formatting Replacement
}
\examples{
'whwdzg, ykybnfg'
fmt('/ hwdzg, ykybnfg',
    'w')
fmt('/ h/ dzg, ykybnfg',
    'w')
fmt('/1 h/ dzg, ykybnfg',
    'w')
fmt('/1 h/ dzg, ykybnfg',
    'w','-w-')

fmt('/ h/1 dzg, ykybnfg',
    'w','-w-')

fmt('/1 h/0 dzg, ykybnfg',
    'w','-w-')


'|w|' |> 
    fmt(x = '/ h/ dzg, ykybnfg')


'|w|' |> 
    fmt(x = '/ h/ dzg, ykybnfg',
        '-w-')
'|w|' |> 
    fmt(x = '/ h/1 dzg, ykybnfg',
        '-w-')
}
