% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xp_pool.R
\name{xp_pool}
\alias{xp_pool}
\title{Calculate Total XP of Monsters for Given Party Level and Difficulty}
\usage{
xp_pool(party_level = NULL, party_size = NULL, difficulty = NULL)
}
\arguments{
\item{party_level}{(numeric) integer indicating the average party level. If all players are the same level, that level is the average party level}

\item{party_size}{(numeric) integer indicating how many player characters (PCs) are in the party}

\item{difficulty}{(character) one of "easy", "medium", "hard", or "deadly" for the desired difficulty of the encounter.}
}
\value{
(numeric) total encounter XP as an integer
}
\description{
Returns the total XP (experience points) of all creatures that would make an encounter the specified level of difficulty for a party of the supplied level. This 'pool' can be used by a GM (game master) to "purchase" monsters to identify how many a party is likely to be able to handle given their average level. NOTE: this does not take into account creature-specific abilities or traits so care should be taken if a monster has many such traits that modify its difficulty beyond its experience point value.
}
\examples{
# Supply a party level and difficulty and get the total XP of such an encounter
xp_pool(party_level = 3, party_size = 2, difficulty = 'medium')

}
