% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome.R
\name{get_biomart_mapping}
\alias{get_biomart_mapping}
\title{Internal function for obtaining biomaRt mapping}
\usage{
get_biomart_mapping(species, symbol_name, dir_save, verbose)
}
\arguments{
\item{species}{The species to obtain a biomart dataset for. This should be
an output from \code{\link{format_species_name}}.}

\item{symbol_name}{The type of gene symbol to use. HGNC symbols are used by
default (hgnc_symbol), unless \code{species} is "mmusculus", in which case MGI
symbols are used (mgi_symbol).}

\item{dir_save}{The directory to store annotation reference. Future
calls to this function will use the stored annotations. This speeds up the
operation and allows for reproducibility in the event that the \code{biomaRt}
database is updated. Set to NULL to disable. By default, it uses a
temporary directory to store files during the R session.}

\item{verbose}{Set to FALSE to avoid messages.}
}
\value{
A data frame containing a mapping between entrezgene IDs and gene
symbols.
}
\description{
Internal function for obtaining biomaRt mapping
}
\keyword{internal}
