% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmri.tracking.R
\name{tractography}
\alias{tractography}
\title{Tractography}
\usage{
tractography(loc, vec)
}
\arguments{
\item{loc}{Voxel coordinates that the reconstructed fiber go through}

\item{vec}{Diffusion direction that used to reconstruct the fiber}
}
\value{
No return value. The reconstructed fiber is visualized on the opened rgl window.
}
\description{
Visualize the result from v.track.
r package \code{\link{rgl}} is required.
}
\examples{
#Load an example output from the peak detection algorithm
load(system.file("extdata", "peakresult.rda", package = "dmri.tracking"))

str(peak.result)  #Output from the peak detection algorithm

#Apply Tracking algorithm
result = v.track(v.obj = peak.result, max.line=500)


#Plot tracking result.
\donttest{
library(rgl)
open3d()
for (iind in (result$sorted.iinds[result$sorted.update.ind])){
  cat(iind,"\n")
  tractography(result$tracks1[[iind]]$inloc, result$tracks1[[iind]]$dir)
  tractography(result$tracks2[[iind]]$inloc, result$tracks2[[iind]]$dir)
}
}
#An example to prepare v.obj is available in https://github.com/vic-dragon/dmri.tracking

}
\references{
R. K. W. Wong, T. C. M. Lee, D. Paul, J. Peng and for the Alzheimer's Disease Neuroimaging Initiative. (2016)
"Fiber Direction Estimation, Smoothing and Tracking in Diffusion MRI". The Annals of Applied Statistics, 10(3), 1137-1156.
}
\seealso{
The tracking result from \code{\link{v.track}} can be used for \code{\link{tractography}} in \code{\link{dmri.tracking}} package.
}
\author{
Raymond Wong, Seungyong Hwang (Maintainer: \email{syhwang@ucdavis.edu})
}
