% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_new_package.R
\name{make_new_package}
\alias{make_new_package}
\title{Create anew package skelleton to add functiuonality to the currently active scheme.}
\usage{
make_new_package(path = ".")
}
\arguments{
\item{path}{path where the package should be created. Default is the current
working directory.}
}
\value{
invisibly \code{NULL}
}
\description{
\strong{This function is not for the user of a scheme, but for the development process of a new scheme.}
}
\details{
A new metadata scheme can be created by using the function
\code{\link{scheme_make}}. This function will create a package to add
functionality to the currently used scheme as a package which will depend on
\code{scheme_active()}. This function uses the function \code{package.skeleton()}
from the \code{utils} package to create a new directory for the new metadata
scheme, and adds a function \code{aaa.R} which loads the current package
whenever the new package is loaded as well as some fields to the
\code{DESCRIPTION} file.

For a documentation of the workflow to create a new scheme, see the vignette
\strong{Howto Create a new scheme}.
}
\examples{
make_new_package(
  path = tempdir()
)
}
