% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmbc_classes.R
\docType{class}
\name{dmbc_data-class}
\alias{dmbc_data-class}
\alias{dmbc_data}
\title{An S4 class to represent the data to use in a DMBC model.}
\description{
An S4 class to represent the data to use in a DMBC model.
}
\section{Slots}{

\describe{
\item{\code{diss}}{A list whose elements are the dissimilarity matrices corresponding
to the judgments expressed by the \emph{S} subjects/raters. These matrices
must be defined as a \code{dist} object.}

\item{\code{n}}{A length-one character vector representing the number of objects
compared by each subject.}

\item{\code{S}}{A length-one numeric vector representing the number of subjects.}

\item{\code{family}}{A length-one character vector representing the type of data to
analyze. Currently, it accepts only the 'binomial' value, but future
developments will include the possibility to analyze continuous,
multinomial and count data.}
}}

\examples{
showClass("dmbc_data")

}
\references{
Venturini, S., Piccarreta, R. (2019), "A Bayesian Approach for Model-Based
  Clustering of Several Binary Dissimilarity Matrices: the \pkg{dmbc}
  Package in \code{R}", Technical report.
}
\author{
Sergio Venturini \email{sergio.venturini@unito.it}
}
