% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm.R
\name{dm_from_src}
\alias{dm_from_src}
\title{dm_from_src()}
\usage{
dm_from_src(src = NULL, table_names = NULL, ...)
}
\arguments{
\item{src}{A \pkg{dplyr} table source object or a
\code{\link[DBI:DBIConnection-class]{DBI::DBIConnection}} object is accepted.}

\item{table_names}{A character vector of the names of the tables to include.}

\item{...}{\lifecycle{experimental}

Additional parameters for the schema learning query.
Currently supports \code{schema} (default: \code{"public"})
and \code{table_type} (default: \code{"BASE TABLE"}) for Postgres databases.}
}
\value{
A \code{dm} object.
}
\description{
\code{dm_from_src()} creates a \link{dm} from some or all tables in a \link{src}
(a database or an environment) or which are accessible via a DBI-Connection.
For Postgres and SQL Server databases, primary and foreign keys
are imported from the database.
}
\examples{
dm_from_src(dplyr::src_df(pkg = "nycflights13"))
}
