% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estDLM.R
\name{estDLM}
\alias{estDLM}
\title{Calculates subgroup-specific lag effects for heterogeneous models}
\usage{
estDLM(
  object,
  new.data,
  group.index,
  conf.level = 0.95,
  exposure = NULL,
  return.mcmc = FALSE,
  mem.safe = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{object}{an object of a model fit. Must be 'hdlm' or 'hdlmm'}

\item{new.data}{a data frame with new observations with the same number of modifiers}

\item{group.index}{a list of index (row numbers) for subgroup specification}

\item{conf.level}{confidence level for credible interval of effects}

\item{exposure}{exposure of interest for 'hdlmm' method}

\item{return.mcmc}{store mcmc in the output}

\item{mem.safe}{boolean memory parameter for rule index}

\item{verbose}{TRUE (default) or FALSE: print output}
}
\value{
A list of distributed lag effects per subgroups
}
\description{
Method for calculating subgroup-specific lag effects for heterogeneous models: HDLM, HDLMM
}
\details{
estDLM
}
