% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_coexposure.R
\name{adj_coexposure}
\alias{adj_coexposure}
\title{Adjusting for expected changes in co-exposure (TDLMM)}
\usage{
adj_coexposure(
  exposure.data,
  object,
  contrast_perc = c(0.25, 0.75),
  contrast_exp = list(),
  conf.level = 0.95,
  keep.mcmc = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{exposure.data}{Named list of exposure matrices used as input to TDLMM.}

\item{object}{Model output for TDLMM from dlmtree() function.}

\item{contrast_perc}{2-length vector of percentiles or named list 
corresponding to lower and upper exposure percentiles of interest.
Names must equal list names in 'exposure.data'.}

\item{contrast_exp}{Named list consisting lower and upper exposure values.
This takes precedence over contrast_perc if both inputs are used.}

\item{conf.level}{Confidence level used for estimating credible intervals.
Default is 0.95.}

\item{keep.mcmc}{If TRUE, return posterior samples.}

\item{verbose}{TRUE (default) or FALSE: print output}
}
\value{
data.frame of plot data with exposure name, posterior mean, and
credible intervals, or posterior samples if keep.mcmc = TRUE
}
\description{
Estimates the marginal effects of an exposure while accounting
for expected changes in co-occurring exposures at the same time point.
Values of co-occurring exposures are modeled nonlinearly using a spline
model with predictions made at the lower an upper values for the exposure
of interest.
}
\details{
adj_coexposure
}
