% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_data.R
\name{sim_data}
\alias{sim_data}
\title{Simulate Data}
\usage{
sim_data(
  x,
  L = NULL,
  modifiers,
  noise = 1,
  type = 2,
  SNR,
  ncovariates = 0,
  gamma = 1
)
}
\arguments{
\item{x}{a time series vector of length \code{n} or matrix of lagged exposures for \code{n} individuals (class "\code{numeric}", "\code{matrix}")}

\item{L}{a vector of length 1 containing the number of lag terms. This is required if \code{x} is vector, and is not used if \code{x} is a matrix (class "\code{numeric}")}

\item{modifiers}{vector of length \code{n} containing modifying values (class "\code{numeric}")}

\item{noise}{a vector of length 1 containing the standard deviation for a normal distribution with mean 0 used to add noise to the simulated response values. Must proivde if \code{SNR} is not provided (class "\code{numeric}")}

\item{type}{a vector containing the number 1, 2, 3, or 4 for simulation modification type: none, linear, non-linear shift, non-linear shift with linear scale (class "\code{numeric}")}

\item{SNR}{The signal-to-noise ratio. If \code{SNR} is provided, but \code{noise} is not, \code{noise} is reset to be the standard deviation of the response, before adding noise.   (class "\code{numeric}")}

\item{ncovariates}{number of covariates to add to the model, numeric vector of length 1.}

\item{gamma}{True coefficient for the main effect of the modifier (class "\code{numeric}")}
}
\value{
This returns a list of 8 items:
\item{x}{a lagged exposure matrix. If \code{x} was a matrix, it is unchanged. (class "\code{matrix}")}
\item{L}{a numeric vector of length 1 containing the number of lag terms (class "\code{numeric}")}
\item{modifiers}{the \code{modifiers} argument (class "\code{numeric}")}
\item{y}{a numeric vector of length \code{nrow(x)} containing the perturbed simulated response values. (class "\code{numeric}")}
\item{betas}{a matrix containing true coefficients for each lag/modifier combination, with each row representing a lag and each column a modifier (class "\code{matrix}")}
\item{betas_cumul}{a numeric vector of length \code{L+1} containing cumulative true coefficients for the lag terms, summed over modifiers (class "\code{numeric}")}
\item{Z}{covariates (class "\code{matrix}")}
\item{gammas}{true coefficients for the covariates (class "\code{numeric}")}
}
\description{
Simulate data to use with the \pkg{dlim} package. There are different effect modification scenarios to choose for simulation.
}
\seealso{
\link[dlim]{sim_dlim}

Type \code{vignette('dlimOverview')} for a detailed description.
}
