% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta.R
\name{ds_delta}
\alias{ds_delta}
\alias{delta}
\title{Compute Delta Index}
\usage{
ds_delta(.data, .cols, .name, .comp = FALSE)

delta(..., .data = dplyr::across(everything()))
}
\arguments{
\item{.data}{\link[tibble:tibble-package]{tibble} with sf geometry}

\item{.cols}{\href{https://tidyselect.r-lib.org/reference/language.html}{\code{tidy-select}}
Columns to compute the measure with. Must be at least 2 columns. If more than 2, treats
first column as first group and sum of other columns as second.}

\item{.name}{name for column with delta index. Leave missing to return a vector.}

\item{.comp}{Default is FALSE. FALSE returns the sum, TRUE returns the components.}

\item{...}{arguments to forward to ds_delta from delta}
}
\value{
a \link[tibble:tibble-package]{tibble} or numeric vector if .name missing
}
\description{
Compute Delta Index
}
\examples{
data("de_county")
ds_delta(de_county, c(pop_white, starts_with('pop_')))
ds_delta(de_county, starts_with('pop_'), 'delta')
}
\concept{concentration}
