% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{ds_correlation}
\alias{ds_correlation}
\alias{correlation}
\title{Compute Correlation Index}
\usage{
ds_correlation(.data, .cols, .name)

correlation(..., .data = dplyr::across(everything()))
}
\arguments{
\item{.data}{\link[tibble:tibble-package]{tibble}}

\item{.cols}{\href{https://tidyselect.r-lib.org/reference/language.html}{\code{tidy-select}}
Columns to compute the measure with. Must be at least 2 columns. If more than 2, treats
first column as first group and sum of other columns as second.}

\item{.name}{name for column with Correlation index. Leave missing to return a vector.}

\item{...}{arguments to forward to ds_correlation from correlation}
}
\value{
a \link[tibble:tibble-package]{tibble} or numeric vector if .name missing
}
\description{
Compute Correlation Index
}
\examples{
data('de_county')
ds_correlation(de_county, c(pop_white, starts_with('pop_')))
ds_correlation(de_county, starts_with('pop_'), 'correlation')
}
\concept{exposure}
