% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abs_cent.R
\name{ds_abs_cent}
\alias{ds_abs_cent}
\alias{abs_cent}
\title{Compute Absolute Centralization}
\usage{
ds_abs_cent(.data, .cols, .name)

abs_cent(..., .data = dplyr::across(everything()))
}
\arguments{
\item{.data}{\link[tibble:tibble-package]{tibble} with sf geometry}

\item{.cols}{\href{https://tidyselect.r-lib.org/reference/language.html}{\code{tidy-select}}
Columns to compute the measure with. Must be at least 2 columns. If more than 2, treats
first column as first group and sum of other columns as second.}

\item{.name}{name for column with absolute centralization. Leave missing to return a vector.}

\item{...}{arguments to forward to ds_abs_cent from abs_cent}
}
\value{
a \link[tibble:tibble-package]{tibble} or numeric vector if .name missing
}
\description{
Compute Absolute Centralization
}
\examples{
data("de_county")
ds_abs_cent(de_county, c(pop_white, starts_with('pop_')))
ds_abs_cent(de_county, c(pop_white, starts_with('pop_')), 'abs_cent')
}
\concept{centralization}
