% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcommunity.R
\name{rcommunity}
\alias{rcommunity}
\title{Random communities}
\usage{
rcommunity(
  n,
  size = sum(abd),
  prob = NULL,
  abd = NULL,
  bootstrap = c("Chao2015", "Marcon2012", "Chao2013"),
  species_number = 300,
  distribution = c("lnorm", "lseries", "geom", "bstick"),
  sd_lnorm = 1,
  prob_geom = 0.1,
  alpha_lseries = 40,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  check_arguments = TRUE
)
}
\arguments{
\item{n}{The number of communities to draw.}

\item{size}{The number of individuals to draw in each community.}

\item{prob}{A numeric vector containing probabilities.}

\item{abd}{A numeric vector containing abundances.}

\item{bootstrap}{The method used to obtain the probabilities to generate
bootstrapped communities from observed abundances.
If "Marcon2012", the probabilities are simply the abundances divided by the total
number of individuals \insertCite{Marcon2012a}{divent}.
If "Chao2013" or "Chao2015" (by default), a more sophisticated approach is used
(see \link{as_probabilities}) following\insertCite{Chao2013;textual}{divent} or
\insertCite{Chao2015;textual}{divent}.}

\item{species_number}{The number of species.}

\item{distribution}{The distribution of species abundances.
May be "lnorm" (log-normal), "lseries" (log-series), "geom" (geometric) or
"bstick" (broken stick).}

\item{sd_lnorm}{The simulated log-normal distribution standard deviation.
This is the standard deviation on the log scale.}

\item{prob_geom}{The proportion of ressources taken by successive species
of the geometric distribution.}

\item{alpha_lseries}{Fisher's alpha in the log-series distribution.}

\item{coverage_estimator}{An estimator of sample coverage used by \link{coverage}.}

\item{check_arguments}{If \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}
}
\value{
An object of class \link{abundances}.
}
\description{
Draw random communities according to a probability distribution.
}
\details{
Communities of fixed \code{size} are drawn in a multinomial distribution according
to the distribution of probabilities provided by \code{prob}.
An abundance vector \code{abd} may be used instead of probabilities,
then \code{size} is by default the total number of individuals in the vector.
Random communities can be built by drawing in a multinomial law following
\insertCite{Marcon2012a;textual}{divent}, or trying to estimate the
distribution of the actual community with \link{as_probabilities}.
If \code{bootstrap} is "Chao2013", the distribution is estimated by a single
parameter model and unobserved species are given equal probabilities.
If \code{bootstrap} is "Chao2015", a two-parameter model is used and unobserved
species follow a geometric distribution.

Alternatively, the probabilities may be drawn following a classical
distribution: either lognormal ("lnorm")  \insertCite{Preston1948}{divent}
with given standard deviation (\code{sd_lnorm}; note that the mean is actually
a normalizing constant. Its values is set equal to 0 for the simulation of
the normal distribution of unnormalized log-abundances), log-series ("lseries")
\insertCite{Fisher1943}{divent} with parameter \code{alpha}, geometric
("geom") one \insertCite{Motomura1932}{divent} with parameter \code{prob_geom},
or broken stick ("bstick") \insertCite{MacArthur1957}{divent}.
The number of simulated species is fixed by \code{species_number}, except for
"lseries" where it is obtained from \code{alpha_lseries} and \code{size}:
\eqn{S=\alpha \ln(1 + size / \alpha)}.

Log-normal, log-series and broken-stick distributions are stochastic.
The geometric distribution is completely determined by its parameters.
}
\examples{
# Generate a community made of 100000 individuals among 300 species and fit it
abundances <- rcommunity(n = 1, size = 1E5, 
  species_number = 300, distribution = "lnorm")
autoplot(abundances)
}
