% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabinate.R
\name{tabinate}
\alias{tabinate}
\title{Apply function to TAxon/BIN subset of occurrences and iterATE}
\usage{
tabinate(x, bin = NULL, tax = NULL, FUN = NULL, ...)
}
\arguments{
\item{x}{\code{(data.frame)} Fossil occurrence table.}

\item{bin}{\code{(character)} Variable name of the bin numbers of the occurrences. This variable should be \code{numeric}.}

\item{tax}{\code{(character)} Variable name of the occurring taxa (variable type: \code{factor} or \code{character} - such as \code{"genus"}}

\item{FUN}{(\code{function}) The function applied to the subset of occurrences. The subset of occurence data will be passed to this function as \code{x}.}

\item{...}{arguments passed to \code{FUN}}
}
\description{
The function takes another function and reruns it on every taxon- and/or bin-specific subsets of an occurrence dataset.
}
\details{
The main \code{tabinate} function acts as a wrapper for any type of function that requires a subset of the occurrence dataset that represents either one \code{bin} or one \code{tax} entry or both.
For example, the iterator can be used to calculate geographic ranges from occurrence coordinates (\code{georange}).

The output structure of FUN should be independent from the input subset, or the function will return an error. 
Setting both \code{bin} If \code{bin=NULL} and code{tax=NULL}, will run \code{FUN} on the entire dataset (no effect). Providing either \code{bin} or \code{tax} and keeping the other \code{NULL} will iterate \code{FUN} for every \code{bin} or \code{tax} entry (whichever is presented).
The function returns a vector of values if the return value of \code{FUN} is a single value. In case it is a vector, the final output will be a matrix. 
When both \code{bin} and \code{tax} is presented, the function output will be a matrix (one output value for a taxon/bin subset) or an array (3d, when \code{FUN} returns a vector).  Setting \code{FUN} to \code{NULL} will return the occurrence dataset as \code{list}s.
}
\examples{
 data(corals)

# the number of different coordinate pairs in every time slice
  tabinate(corals, bin="stg", FUN=georange, lat="paleolat", 
    lng="paleolng", method="co")
# geographic range (site occupancy) of every taxon in every bin
  tabinate(corals, bin="stg", tax="genus", FUN=georange, 
    lat="paleolat", lng="paleolng", method="co")

}
