% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogNormal.R
\name{cdf.LogNormal}
\alias{cdf.LogNormal}
\title{Evaluate the cumulative distribution function of a LogNormal distribution}
\usage{
\method{cdf}{LogNormal}(d, x, ...)
}
\arguments{
\item{d}{A \code{LogNormal} object created by a call to \code{\link[=LogNormal]{LogNormal()}}.}

\item{x}{A vector of elements whose cumulative probabilities you would
like to determine given the distribution \code{d}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of probabilities, one for each element of \code{x}.
}
\description{
Evaluate the cumulative distribution function of a LogNormal distribution
}
\examples{

set.seed(27)

X <- LogNormal(0.3, 2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

}
\seealso{
Other LogNormal distribution: 
\code{\link{fit_mle.LogNormal}()},
\code{\link{pdf.LogNormal}()},
\code{\link{quantile.LogNormal}()},
\code{\link{random.LogNormal}()}
}
\concept{LogNormal distribution}
