% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Logistic.R
\name{Logistic}
\alias{Logistic}
\title{Create a Logistic distribution}
\usage{
Logistic(location = 0, scale = 1)
}
\arguments{
\item{location}{The location parameter for the distribution. For Logistic
distributions, the location parameter is the mean, median and also mode.
Defaults to zero.}

\item{scale}{The scale parameter for the distribution. Defaults to one.}
}
\value{
A \code{Logistic} object.
}
\description{
A continuous distribution on the real line. For binary outcomes
the model given by \eqn{P(Y = 1 | X) = F(X \beta)} where
\eqn{F} is the Logistic \code{\link[=cdf]{cdf()}} is called \emph{logistic regression}.
}
\details{
We recommend reading this documentation on
\url{https://alexpghayes.github.io/distributions3/}, where the math
will render with additional detail and much greater clarity.

In the following, let \eqn{X} be a Logistic random variable with
\code{location} = \eqn{\mu} and \code{scale} = \eqn{s}.

\strong{Support}: \eqn{R}, the set of all real numbers

\strong{Mean}: \eqn{\mu}

\strong{Variance}: \eqn{s^2 \pi^2 / 3}

\strong{Probability density function (p.d.f)}:

\deqn{
    f(x) = \frac{e^{-(\frac{x - \mu}{s})}}{s [1 + \exp(-(\frac{x - \mu}{s})) ]^2}
  }{
    f(x) = e^(-(t - \mu) / s) / (s (1 + e^(-(t - \mu) / s))^2)
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    F(t) = \frac{1}{1 + e^{-(\frac{t - \mu}{s})}}
  }{
    F(t) = 1 / (1 +  e^(-(t - \mu) / s))
  }

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = e^{\mu t} \beta(1 - st, 1 + st)
  }{
    E(e^(tX)) = = e^(\mu t) \beta(1 - st, 1 + st)
  }

where \eqn{\beta(x, y)} is the Beta function.
}
\examples{

set.seed(27)

X <- Logistic(2, 4)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)
}
\seealso{
Other continuous distributions: 
\code{\link{Beta}()},
\code{\link{Cauchy}()},
\code{\link{ChiSquare}()},
\code{\link{Erlang}()},
\code{\link{Exponential}()},
\code{\link{FisherF}()},
\code{\link{Frechet}()},
\code{\link{GEV}()},
\code{\link{GP}()},
\code{\link{Gamma}()},
\code{\link{Gumbel}()},
\code{\link{LogNormal}()},
\code{\link{Normal}()},
\code{\link{RevWeibull}()},
\code{\link{StudentsT}()},
\code{\link{Tukey}()},
\code{\link{Uniform}()},
\code{\link{Weibull}()}
}
\concept{continuous distributions}
