% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_extractors.R
\name{dist_extract}
\alias{dist_extract}
\title{Matrix style extraction from dist object}
\usage{
dist_extract(object, i, j, k, product = "outer")
}
\arguments{
\item{object}{dist object}

\item{i}{(integer vector) row positions}

\item{j}{(integer vector) column positions}

\item{k}{(integer vector) positions}

\item{product}{(string) One among: 'inner', 'outer'(default)}
}
\value{
A matrix or vector of distances when product is 'outer' and 'inner'
  respectively
}
\description{
Matrix style extraction supports 'inner' and 'outer'(default)
  products
}
\details{
In k-mode, both i and j should be missing and k should not be
  missing. In ij-mode, k should be missing and both i and j are optional. If
  i or j are missing, they are interpreted as all values of i or j (similar
  to matrix or dataframe subsetting). If i and j are of unequal length, the
  smaller one is recycled.
}
\examples{
# examples for dist_extract

# create a dist object
temp <- dist(iris[,1:4])
attr(temp, "Labels") <- outer(letters, letters, paste0)[1:150]
head(temp)
max(temp)
as.matrix(temp)[1:5, 1:5]


dist_extract(temp, 1, 1)
dist_extract(temp, 1, 2)
dist_extract(temp, 2, 1)
dist_extract(temp, "aa", "ba")

dist_extract(temp, 1:10, 11:20)
dim(dist_extract(temp, 1:10, ))
dim(dist_extract(temp, , 1:10))
dist_extract(temp, 1:10, 11:20, product = "inner")
length(dist_extract(temp, 1:10, , product = "inner"))
length(dist_extract(temp, , 1:10, product = "inner"))

dist_extract(temp, c("aa", "ba", "ca"), c("ca", "da", "fa"))
dist_extract(temp, c("aa", "ba", "ca"), c("ca", "da", "fa"), product = "inner")

dist_extract(temp, k = 1:3) # product is always inner when k is specified
}
