% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoo_time.R
\name{zoo_time}
\alias{zoo_time}
\title{Get Time Features from Zoo Objects}
\usage{
zoo_time(x = NULL, keywords = c("resample", "aggregate"))
}
\arguments{
\item{x}{(required, zoo object) Zoo time series to analyze. Default: NULL.}

\item{keywords}{(optional, character string or vector) Defines what keywords are returned. If "aggregate", returns valid keywords for \code{\link[=zoo_aggregate]{zoo_aggregate()}}. If "resample", returns valid keywords for \code{\link[=zoo_resample]{zoo_resample()}}. If both, returns all valid keywords. Default: c("aggregate", "resample").}
}
\value{
Data frame with the following columns:
\itemize{
\item \code{name} (string): time series name.
\item \code{rows} (integer): number of observations.
\item \code{class} (string): time class, one of "Date", "POSIXct", or "numeric."
\item \code{units} (string): units of the time series.
\item \code{length} (numeric): total length of the time series expressed in \code{units}.
\item \code{resolution} (numeric): average interval between observations expressed in \code{units}.
\item \code{begin} (date or numeric): begin time of the time series.
\item \code{end} (date or numeric): end time of the time series.
\item \code{keywords} (character vector): valid keywords for \code{\link[=tsl_aggregate]{tsl_aggregate()}} or \code{\link[=tsl_resample]{tsl_resample()}}, depending on the value of the argument \code{keywords}.
}
}
\description{
This function generates a data frame summarizing the time features (class, length, resolution, and others) of zoo time series.
}
\examples{
#simulate a zoo time series
x <- zoo_simulate(
  rows = 150,
  time_range = c(
    Sys.Date() - 365,
    Sys.Date()
  ),
  irregular = TRUE
)

#time data frame
zoo_time(
  x = x
)
}
\seealso{
Other zoo_functions: 
\code{\link{zoo_aggregate}()},
\code{\link{zoo_name_clean}()},
\code{\link{zoo_name_get}()},
\code{\link{zoo_name_set}()},
\code{\link{zoo_permute}()},
\code{\link{zoo_plot}()},
\code{\link{zoo_resample}()},
\code{\link{zoo_smooth_exponential}()},
\code{\link{zoo_smooth_window}()},
\code{\link{zoo_to_tsl}()},
\code{\link{zoo_vector_to_matrix}()}
}
\concept{zoo_functions}
