% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distantia_boxplot.R
\name{distantia_boxplot}
\alias{distantia_boxplot}
\title{Distantia Boxplot}
\usage{
distantia_boxplot(df = NULL, fill_color = NULL, f = median, text_cex = 1)
}
\arguments{
\item{df}{(required, data frame) Output of \code{\link[=distantia]{distantia()}}, \code{\link[=distantia_ls]{distantia_ls()}}, \code{\link[=distantia_dtw]{distantia_dtw()}}, or \code{\link[=distantia_time_delay]{distantia_time_delay()}}. Default: NULL}

\item{fill_color}{(optional, character vector) boxplot fill color. Default: NULL}

\item{f}{(optional, function) function used to aggregate the input data frame and arrange the boxes. One of \code{mean} or \code{median}. Default: \code{median}.}

\item{text_cex}{(optional, numeric) Multiplier of the text size. Default: 1}
}
\value{
boxplot
}
\description{
Boxplot of a data frame returned by \code{\link[=distantia]{distantia()}} summarizing the stats of the psi scores of each time series against all others.
}
\examples{
tsl <- tsl_initialize(
  x = distantia::albatross,
  name_column = "name",
  time_column = "time"
) |>
  tsl_transform(
    f = f_scale_global
  )

df <- distantia(
  tsl = tsl,
  lock_step = TRUE
  )

distantia_boxplot(
  df = df,
  text_cex = 1.5
  )
}
\seealso{
Other distantia_support: 
\code{\link{distantia_aggregate}()},
\code{\link{distantia_cluster_hclust}()},
\code{\link{distantia_cluster_kmeans}()},
\code{\link{distantia_matrix}()},
\code{\link{distantia_model_frame}()},
\code{\link{distantia_spatial}()},
\code{\link{distantia_stats}()},
\code{\link{distantia_time_delay}()},
\code{\link{utils_block_size}()},
\code{\link{utils_cluster_hclust_optimizer}()},
\code{\link{utils_cluster_kmeans_optimizer}()},
\code{\link{utils_cluster_silhouette}()}
}
\concept{distantia_support}
