% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsl_count_NA.R
\name{tsl_count_NA}
\alias{tsl_count_NA}
\title{Count NA Cases in Time Series Lists}
\usage{
tsl_count_NA(tsl = NULL)
}
\arguments{
\item{tsl}{(required, list) Time series list. Default: NULL}
}
\value{
list
}
\description{
Converts Inf, -Inf, and NaN to NA (via \code{\link[=tsl_Inf_to_NA]{tsl_Inf_to_NA()}} and \code{\link[=tsl_NaN_to_NA]{tsl_NaN_to_NA()}}), and counts the total number of NA cases in each time series.
}
\examples{
#tsl with no NA cases
tsl <- tsl_simulate()

tsl_count_NA(tsl = tsl)

#tsl with NA cases
tsl <- tsl_simulate(
  na_fraction = 0.3
)

tsl_count_NA(tsl = tsl)

#tsl with variety of empty cases
tsl <- tsl_simulate()
tsl[[1]][1, 1] <- Inf
tsl[[1]][2, 1] <- -Inf
tsl[[1]][3, 1] <- NaN
tsl[[1]][4, 1] <- NaN

tsl_count_NA(tsl = tsl)

}
\seealso{
Other tsl_management: 
\code{\link{tsl_burst}()},
\code{\link{tsl_colnames_clean}()},
\code{\link{tsl_colnames_get}()},
\code{\link{tsl_colnames_prefix}()},
\code{\link{tsl_colnames_set}()},
\code{\link{tsl_colnames_suffix}()},
\code{\link{tsl_diagnose}()},
\code{\link{tsl_handle_NA}()},
\code{\link{tsl_join}()},
\code{\link{tsl_names_clean}()},
\code{\link{tsl_names_get}()},
\code{\link{tsl_names_set}()},
\code{\link{tsl_names_test}()},
\code{\link{tsl_ncol}()},
\code{\link{tsl_nrow}()},
\code{\link{tsl_repair}()},
\code{\link{tsl_subset}()},
\code{\link{tsl_time}()},
\code{\link{tsl_to_df}()}
}
\concept{tsl_management}
