% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distantia_aggregate.R
\name{distantia_aggregate}
\alias{distantia_aggregate}
\title{Aggregate \code{distantia()} Data Frames Across Parameter Combinations}
\usage{
distantia_aggregate(df = NULL, f = mean, ...)
}
\arguments{
\item{df}{(required, data frame) Output of \code{\link[=distantia]{distantia()}}, \code{\link[=distantia_ls]{distantia_ls()}}, \code{\link[=distantia_dtw]{distantia_dtw()}}, or \code{\link[=distantia_time_delay]{distantia_time_delay()}}. Default: NULL}

\item{f}{(optional, function) Function to summarize psi scores (for example, \code{mean}) when there are several combinations of parameters in \code{df}. Ignored when there is a single combination of arguments in the input. Default: \code{mean}}

\item{...}{(optional, arguments of \code{f}) Further arguments to pass to the function \code{f}.}
}
\value{
data frame
}
\description{
The function \code{\link[=distantia]{distantia()}} allows dissimilarity assessments based on several combinations of arguments at once. For example, when the argument \code{distance} is set to \code{c("euclidean", "manhattan")}, the output data frame will show two dissimilarity scores for each pair of compared time series, one based on euclidean distances, and another based on manhattan distances.

This function computes dissimilarity stats across combinations of parameters.

If psi scores smaller than zero occur in the aggregated output, then the the smaller psi value is added to the column \code{psi} to start dissimilarity scores at zero.

If there are no different combinations of arguments in the input data frame, no aggregation happens, but all parameter columns are removed.
}
\examples{
#three time series
#climate and ndvi in Fagus sylvatica stands in Spain, Germany, and Sweden
tsl <- tsl_initialize(
  x = fagus_dynamics,
  name_column = "name",
  time_column = "time"
) |>
  tsl_transform(
    f = f_scale_global
  )

if(interactive()){
  tsl_plot(
    tsl = tsl,
    guide_columns = 3
    )
}

#distantia with multiple parameter combinations
#-------------------------------------
df <- distantia(
  tsl = tsl,
  distance = c("euclidean", "manhattan"),
  lock_step = TRUE
)

df[, c(
  "x",
  "y",
  "distance",
  "psi"
)]

#aggregation using means
df <- distantia_aggregate(
  df = df,
  f = mean
)

df
}
\seealso{
Other distantia_support: 
\code{\link{distantia_boxplot}()},
\code{\link{distantia_cluster_hclust}()},
\code{\link{distantia_cluster_kmeans}()},
\code{\link{distantia_matrix}()},
\code{\link{distantia_model_frame}()},
\code{\link{distantia_spatial}()},
\code{\link{distantia_stats}()},
\code{\link{distantia_time_delay}()},
\code{\link{utils_block_size}()},
\code{\link{utils_cluster_hclust_optimizer}()},
\code{\link{utils_cluster_kmeans_optimizer}()},
\code{\link{utils_cluster_silhouette}()}
}
\concept{distantia_support}
