% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dist2Mat.R
\name{Dist2Mat}
\alias{Dist2Mat}
\title{Dist2Mat conversion}
\usage{
Dist2Mat(dist)
}
\arguments{
\item{dist}{A "dist" object, which can be computed via the stats::dist function, representing pairwise distances between observations.}
}
\value{
A distance "matrix".
}
\description{
Efficiently converts a "dist" object into a symmetric distance "matrix".
}
\details{
Converts a "dist" object, typically created using the stats::dist function, into a symmetric matrix form.
This implementation is optimised for speed and performs significantly faster than base::as.matrix or proxy::as.matrix
when applied to "dist" objects.
}
\examples{

library("microbenchmark")
x = matrix(rnorm(200), nrow = 50)
dx = dist(x)
#Dist2Mat conversion
microbenchmark(base::as.matrix(dx),
               proxy::as.matrix(dx),
               Dist2Mat(dx))
#Check if equal
v1 = as.vector(base::as.matrix(dx))
v2 = as.vector(Dist2Mat(dx))
all.equal(v1, v2)

}
\author{
Minh Long Nguyen \email{edelweiss611428@gmail.com}
}
