% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{normalize_DF}
\alias{normalize_DF}
\title{Normalize variable}
\usage{
normalize_DF(
  data,
  var.name,
  method = "mean",
  norm.number,
  return = "add.end",
  digits = 2
)
}
\arguments{
\item{data}{data frame with numeric variable that should be normalized}

\item{var.name}{character; data frame column name with numeric variable that should be normalized}

\item{method}{character; normalization method; possible values are: \code{"mean"} (normalize to mean),
\code{"median"} (normalize to median), \code{"number"} (normalize to given number)}

\item{norm.number}{numeric; a value to normalize to (if \code{method = "number"})}

\item{return}{character; return object; possible values are: \code{"vector"} (return a vector of normalized values),
\code{"replace"} (replace \code{var.name} values with normalized values in data frame),
\code{"add.near"} (add normalized values next to \code{var.name} values in data frame),
\code{"add.end"} (add normalized values as the latter column in data frame)}

\item{digits}{integer; number of decimal places to round the normalized value}
}
\value{
Vector or data frame with normalized values.
}
\description{
Normalize variable in a data frame
}
\details{
This function scales variable to a range of (0-1), where 1 get values that are the most close to mean, median or given number.
See \link[BBmisc]{normalize} for details.

\code{var.name} must be exact column name as in data frame.
}
\examples{
data <- data.frame (N = 1:5, temperature = c(37.5, 36.6, 41.2, 38.8, 36.7),
                name = c("Bob", "Kate", "Steve", "Sonya", "Mary"))
normalize_DF (data = data, var.name = "temperature", method = "mean", return = "vector")
normalize_DF (data = data, var.name = "temperature", method = "mean", return = "replace")
normalize_DF (data = data, var.name = "temperature", method = "mean", return = "add.near")
normalize_DF (data = data, var.name = "temperature", method = "number",
            norm.number = 36.6, return = "add.end")

}
\author{
Elena N. Filatova
}
