% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R, R/diseq_basic.R,
%   R/diseq_deterministic_adjustment.R, R/diseq_directional.R,
%   R/diseq_stochastic_adjustment.R, R/equilibrium_model.R
\name{minus_log_likelihood}
\alias{minus_log_likelihood}
\alias{minus_log_likelihood,diseq_basic-method}
\alias{minus_log_likelihood,diseq_deterministic_adjustment-method}
\alias{minus_log_likelihood,diseq_directional-method}
\alias{minus_log_likelihood,diseq_stochastic_adjustment-method}
\alias{minus_log_likelihood,equilibrium_model-method}
\title{Minus log-likelihood.}
\usage{
minus_log_likelihood(object, parameters)

\S4method{minus_log_likelihood}{diseq_basic}(object, parameters)

\S4method{minus_log_likelihood}{diseq_deterministic_adjustment}(object, parameters)

\S4method{minus_log_likelihood}{diseq_directional}(object, parameters)

\S4method{minus_log_likelihood}{diseq_stochastic_adjustment}(object, parameters)

\S4method{minus_log_likelihood}{equilibrium_model}(object, parameters)
}
\arguments{
\item{object}{A model object.}

\item{parameters}{A vector of parameters at which the function is to be evaluated.}
}
\value{
The opposite of the sum of the likelihoods evaluated for each observation.
}
\description{
Returns the opposite of the log-likelihood. The likelihood functions are based on
Maddala and Nelson (1974) \doi{10.2307/1914215}. The likelihoods expressions
that the function uses are derived in
Karapanagiotis (2020) \doi{10.2139/ssrn.3525622}. The function calculates
the model's log likelihood by evaluating the log likelihood of each observation in
the sample and summing the evaluation results.
}
